/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.setting.settings;

import Krasnodar.rockstarnew.systems.setting.SettingsContainer;
import Krasnodar.rockstarnew.systems.setting.impl.AbstractSetting;
import Krasnodar.rockstarnew.utility.colors.ColorRGBA;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.BooleanSupplier;
import lombok.Generated;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

public class ColorSetting
extends AbstractSetting {
    private ColorRGBA color;
    private boolean alpha = true;

    public ColorSetting(@NotNull SettingsContainer parent, String name, @NotNull BooleanSupplier hideCondition) {
        super(parent, name, hideCondition);
    }

    public ColorSetting(@NotNull SettingsContainer parent, String name) {
        super(parent, name);
    }

    public ColorSetting color(ColorRGBA color) {
        this.color = color;
        return this;
    }

    public ColorSetting alpha(boolean alpha) {
        this.alpha = alpha;
        return this;
    }

    @Override
    public JsonElement save() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("r", (Number)Float.valueOf(this.color.getRed()));
        jsonObject.addProperty("g", (Number)Float.valueOf(this.color.getGreen()));
        jsonObject.addProperty("b", (Number)Float.valueOf(this.color.getBlue()));
        jsonObject.addProperty("a", (Number)Float.valueOf(this.color.getAlpha()));
        return jsonObject;
    }

    @Override
    public void load(JsonElement element) {
        if (element.isJsonObject()) {
            JsonObject jsonObject = element.getAsJsonObject();
            int red = jsonObject.get("r").getAsInt();
            int green = jsonObject.get("g").getAsInt();
            int blue = jsonObject.get("b").getAsInt();
            int alpha = jsonObject.get("a").getAsInt();
            this.color = new ColorRGBA(this.validateColorRange(red), this.validateColorRange(green), this.validateColorRange(blue), this.validateColorRange(alpha));
        }
    }

    private int validateColorRange(int in) {
        return class_3532.method_15340((int)in, (int)0, (int)255);
    }

    @Generated
    public ColorRGBA getColor() {
        return this.color;
    }

    @Generated
    public boolean isAlpha() {
        return this.alpha;
    }

    @Generated
    public void setColor(ColorRGBA color) {
        this.color = color;
    }

    @Generated
    public void setAlpha(boolean alpha) {
        this.alpha = alpha;
    }
}

